# 第二章 中国开源开发者发展现状

开源，全球智慧成果共享、科技发展的时代产物。作为创新的驱动力及源泉，开发者从早期开源软件的使用者，逐渐演变为贡献者、维护者，最后成为开源创作者，其整个的成长历程也贯穿着开源软件的落地、开源社区的构建、开源治理的模型制定等方方面面。开源开发者的行为数据蕴含了大量的个体贡献规律、群体协作模式、社区健康状况、生态发展趋势、以及商业战略价值，正是由于越来越多的开发者参与、贡献，中国开源生态的发展已然呈现出一个欣欣向荣的态势。
 
## 2.1 中国开发者的规模和增速，全球最快

“开源正在吞噬世界”，这一观点已成为诸多科技从业者的共识。随着开源的迅速发展，以及数字化对基础设施的改造，“家家都是技术公司，人人都是开发者”背后的十万亿开发者新生态正在迅速形成。
 
根据GitHub 2021年数据统计，GitHub开发者数量达到了7300万，新增用户人数为1600万。在全球总开发者数量中，美国开发者数量最多，共有1355万； 中国排名第二，相比2020年中国的 GitHub开发者人数为652万，2021年中国在GitHub上的开发者新增了近103万，已增至755万，可见中国已有越来越多的开发者在拥抱开源。

![](https://img-blog.csdnimg.cn/0c628c0336f74f84b3d77c2a5a129c4b.png)

据CNCF(CloudNativeComputingFoundation，云原生计算基金会，以下简称“CNCF”)的统计，截至2022年2月，CNCF超过20%的开源项目来自中国，贡献度排名上升至世界第二。中国互联网企业积极加入国际云原生开源社区参与贡献。2021年，CNCF在全球范围内新增200+个会员单位，其中有80家来自中国。目前CNCF在中国总共拥有上百个会员单位，占CNCF会员总数的10％以上。当前国内已经有25个开源项目进入了CNCF，占了基金会所有项目的20%以上，同时这些项目多为边缘计算、AI批量计算、多云管理、混沌工程、分布式存储与WebAssembly等前沿技术，这些领域被CNCF技术委员会认定为云原生未来的主要方向。
 
根据国内主流的技术社区及论坛的注册用户评估中国开发者的整体规模，其中CSDN作为全球第二大、中国最大的开发者社区，拥有超过3500万的开发者用户。CSDN旗下的开源项目创新服务平台GitCode，致力于为大规模开源开放协同创新助力赋能，打造创新成果孵化和新时代开发者培养的开源创新生态。

另一大技术社区SegmentFault思否注册开发者超过660万，年增长超过50万。

## 2.2 中国开发者不断沉淀和积累，技术管理占比越来越高

### 2.2.1 中国开发者的基本画像

根据CSDN发布的《2021-2022 中国开发者现状调查报告》显示，我们将开发者根据年龄范围划分成三类，对不同年龄段开发者群体进行特征分析后，呈现出如下特点。30岁以下从业者比例从82%（2019 年）、81%（2020 年），再度下降至78%。与之形成对比的是，30-40岁从业者从2020 年报告中16%的占比提升至2021 年的19%。

![](https://img-blog.csdnimg.cn/d9b57b2dfcc847c2a2223e71a131cb02.png)<br/>*开发者基本特征*

40岁以下的女性开发者比例也在上升。结合去年报告，30岁以下女性从业者占比达到了 12%（去年为10%），同时在 30-40岁程序员中，女性也占据了8%（去年为6%）。

从开发者的编程时长中可以看出，依旧有超过7成开发者的开发经验不足5年。这意味着随着时间推移，越来越多开发者的开发经验随着积累，向着资深维度发展，这也为中国IT 的发展奠定良好的人才基础。

![](https://img-blog.csdnimg.cn/29f12c39e2dd48148ab803c18220e2a1.png)<br/>*从事编程时长*

### 2.2.2 中国开发者的职业分类
 
当前行业中的开发者群体主要分为三个维度，一是未正式步入互联网领域但已参与到开发领域的学生群体，二是位居一线开发岗位的开发工程师，三是管理层的技术经理。软件行业涵盖了国内近半数的开发者。在40岁以下程序员圈中，后端开发岗依旧热门。40岁以上从业者中，担任技术经理的占比从去年的11%提升至21%，可见随着年龄的增长，越来越多开发者开始走上了技术管理之路。
 
### 2.2.3 中国开发者的地域分布
 
在地域分布上，近70%的国内开发者还是喜欢聚集在一线/新一线城市。
北京、广东是开发者聚集最多的地域，占全国总数28.1%。数年以来，拥有“北上广深”其二的广东一直和北京处于焦灼状态，在2020年，广东以16%的开发者占比位列全国第一的位置，而今年，这一宝座则由北京以14.2%的占比拿下。紧随北京、广东之后的是上海和江苏，占全国总数16.1%。

![](https://img-blog.csdnimg.cn/aca3302b7d8949f39a877a255ed3ce1d.png)<br/>*开发者地域分布（省、自治区、直辖市、特别行政区）Top15*

## 2.3 中国开发者对开源的热衷度越来越强烈
 
### 2.3.1 中国开发者社区开源技术内容与活动热度
 
**趋势一：开发者驱动下的中国开源项目陆续登上国际舞台，吸引全球开发者参与其中**

根据Apache软件基金会（简称ASF）发布的2021财年年度报告显示，全球活动收到了来自228个国家的用户共4095908次访问，其中中国用户访问次数最多，这意味着国内用户成为了Apache项目的主要使用者。

在共计821名的ASF基金会成员中，有44名是中国成员，占比5%。

![](https://img-blog.csdnimg.cn/116eb65f3e8d434099253caa67846de6.png)

在项目活跃度TOP 10中，中国项目IoTDB排名第7，ShardingSphere排名第10。

![](https://img-blog.csdnimg.cn/efbb72dcce644eac84de14002259c74e.png)

同时当前ASF孵化项目总计37个，其中10个来自于中国。2021年Apache新增孵化项目5个，全部来自于中国，占比100%。

![](https://img-blog.csdnimg.cn/08e52b12b03d406ab92ab798fa445759.png)

**趋势二：开源话题热度爆表，众多开发者和技术内容创作者开始关注开源，产出开源技术内容**
 
作为中国开源开发者最集中的专业社区，截至5月20日，CSDN网站的开源标签下已收录了243万篇相关话题的文章，如开源社、NGINX、Oneflow、TiDB 等数百家知名开源社区官方账户入驻CSDN博客，围绕开源工具、头部企业开源动态、开源社区大事记、开源人物的程序人生等主题，分享开源方面的实践与开发经验。同时，CSDN邀请来自IBM、英特尔、华为、阿里巴巴、字节跳动、腾讯、网易等企业的一线开源专家，立足于大厂、个人的亲身实践，共同创作开发者权威出版物《新程序员》，受到了业界诸多开发者的好评。

根据以社区为中心的技术媒体平InfoQ的官网【开源】频道数据显示，截至2022年3月9日共收录内容3772篇，重点关注领域包括大数据、前端、移动开发、中间件、微服务、容器、Serverless等。报道频次排在前列的企业包括阿里、腾讯、百度、Facebook、Google、蚂蚁、滴滴、字节、Amazon、小米等，大部分也是在开源领域表现活跃且投入较大的科技公司，同时也有一些基于开源做商业化的初创企业表现活跃，如PingCAP、StreamNative、SphereEx等。

众多开源项目/开源商业公司入驻SegmentFault思否等开发者社区，开设专栏并发布高质量技术内容，比较典型的有：PingCAP、涛思数据、ApacheFlink、SphereEx、Apache APISIX等。越来越多科技企业关注开发者生态与开源生态建设，SegmentFault思否主办的开发者生态峰会得到了全行业关注，线下参会人数超500人，线上资料下载超2万次。
 
在主流的技术社区推动下，越来越多科技企业关注开发者生态与开源生态建设。
 
**趋势三：开源技术活动井喷式增加**
 
为推动优秀开源项目的快速发展，CSDN组织了《IT技术影响力之星开发者生态汇》、1024程序员节等年度盛会，遴选优秀开源项目，与更多开源企业、组织及开源开发者一起，共建开源开发者大生态。与此同时，CSDN还策划了《开源圆桌派》、《开源访谈录》开源主题栏目档，聚焦业界广泛关注的开源话题，每周邀请多位具代表性及影响力的开源专家，从不同角度还原开源圈真实面貌。
 
技术问答社区SegmentFault思否在2020-2021 年的开源技术活动也达到了上百场，几乎每一个周末都有由社区或科技企业组织的开源技术沙龙。特别值得一提的是，在过去一年也有来自国际顶级基金会的开源技术活动首次落地中国，如首届Apache软件基金会亚洲大会于2021年8月在线上召开，其中来自中国的讲师超过了百位。
 
**趋势四：越来越多的开源技术受到关注**
 
随着开源的爆发，新项目也如雨后春笋般涌现出来，其中关注热度明显上升的技术方向有大前端与跨平台开发、云原生、大数据、人工智能、开源基础设施（数据库、中间件、RISC-V、ARM 架构）、Web3 与区块链等等。
 
### 2.3.2 中国开发者开源参与与贡献
 
从中国的开源整体发展来看，中国开发者的影响力在加速增长：开发者对开源关注度持续升高，参与开源的人数持续增长，参与质量提升显著。这构成了中国开源产业的人才基础。从贡献度来看，中国顶级开源项目的贡献度逐年增加，中国在国际开源事务中影响力日渐提升，并在国际社区中增加了贡献度。
 
据CSDN数据报告显示，开源已经成为基础设施的基石，在日常的开发工作中，我们不可避免地要使用到开源软件。94%的开发者正在使用开源软件，仅有2%的开发者表示从未使用开源软件。

![](https://img-blog.csdnimg.cn/48ec985892f4450f942e862ff75f0fa7.png)

当然，使用开源，自己也参与开源回馈开源。相较去年32%的开发者参与过开源，今年有较大幅的增长，今年有42%的开发者表示参与过开源。

![](https://img-blog.csdnimg.cn/94fec98f88c1462498026d2135594d52.png)<br/>*开发者参与开源比例*

60%的开发者每周在开源上投入的时间不超过5小时，随着开源的发展，有更多的人从事开源相关的工作，数据显示，有7%的开发者每周在开源上投入30小时以上。

![](https://img-blog.csdnimg.cn/3388f6883baf4054a74952f80cbcc3f5.png)<br/>*开发者每周在开源上的投入*

### 2.3.3 开源引发的安全问题也成为不容忽视的重要一部分

对于开发者而言，开源当前还存在一定的挑战。68%的开发者表示，自己未曾在开源中获得收入。不过相较去年的77%，今年数据有所下降。

![](https://img-blog.csdnimg.cn/ea2aa8b87a5f42e98843a16b06da0ab1.png)<br/>*开发者在开源上获得的收入*

除了收入顾虑层面，由于2021年底突发的Log4j 2漏洞问题几乎覆盖了整个互联网，开源项目的安全性也成为了众多公司考虑的因素。数据显示，23%的公司会担心开源项目的安全问题。这导致开源软件供应链和安全可信的项目开始得到大家重视，但这不是某个厂商或开源社区要解决的问题，它需要全生态来共建，特别需要企业、政府投入资源积极建设维护。

![](https://img-blog.csdnimg.cn/129197ca4b5d488dacea3d6ea3d6827e.png)


**附件：相关报告**

[《GitHub 2021 Octoverse报告》](https://octoverse.github.com/)

[《2020-2021中国开发者调查报告》](https://csdn.gitcode.host/Survey-Report-on-Developers-in-China/survey/)

[《2021 中国开源开发者年度报告》](https://gitee.com/report/china-open-source-2021)

[《Apache软件基金会2021年财报》](https://blogs.apache.org/foundation/entry/apache-in-2021-by-the)

[《Apache软件基金会2021年财报》](https://blogs.apache.org/foundation/entry/the-apache-software-foundation-announces78)

[《CNCF Annual Survey 2021》](https://www.cncf.io/reports/cncf-annual-survey-2021/)
